package de.upb.pga3.panda2.client.core.datastructures;

import java.util.Arrays;
import java.util.List;

/**
 *
 * Enumeration for representing different analysis modes.
 *
 * @author Sriram
 *
 */
public enum Mode {

	// Values specific to this enumeration
	SUMMARY("SUM", "S", "SUMMARY"), COMPARISON("COMP", "COMPARISON", "C");

	// Variable for representing the values available for the selected enum
	private List<String> modes;

	/**
	 * Constructor
	 *
	 * @param String
	 */
	private Mode(final String... mode) {
		this.modes = Arrays.asList(mode);
	}

	/**
	 * Method for getting the values of single enumeration declared in this enum
	 * class
	 *
	 * @return modes, list of String which represents the enum value
	 */
	public List<String> getValues() {
		return this.modes;
	}

	/**
	 * Method for getting the instance of the Mode enumeration based on the
	 * passed String value.
	 *
	 * @param code
	 * @return mode, if the parameter code matches the value of the enumeration.
	 *         else, null value will be returned.
	 */
	public static Mode fromString(final String code) {
		for (final Mode mode : Mode.values()) {
			if (mode.getValues().contains(code.toUpperCase())) {
				return mode;
			}
		}
		return null;
	}

}
