package de.upb.pga3.panda2.client.core.datastructures.validation;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;

/**
 *
 * Class for validating the the input value of the LevelSpecificMode enumeration
 * from JCommander perspective for command line scenario.
 *
 * @author Sriram
 *
 */
public class LevelSpecificModeConverter implements
IStringConverter<LevelSpecificMode> {

	/**
	 * Default Constructor
	 */
	public LevelSpecificModeConverter() {
	}

	/**
	 * Overriden method for converting the String path to LevelSpecificMode
	 * enumeration instance.
	 *
	 * @return a instance of the LevelSpecificMode enumeration.
	 */
	@Override
	public LevelSpecificMode convert(final String value) {
		final LevelSpecificMode convertedValue = LevelSpecificMode
				.fromString(value);
		if (convertedValue == null) {
			throw new ParameterException("Value " + value
					+ "can not be converted to LevelSpecificMode. "
					+ "Available values are: App, All.");
		}
		return convertedValue;
	}
}
