package de.upb.pga3.panda2.client.core.datastructures.validation;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.Mode;

/**
 *
 * Class for validating the input value of the Mode enumeration from JCommander
 * perspective for command line scenario.
 *
 * @author Sriram
 *
 */
public class ModeConverter implements IStringConverter<Mode> {

	/**
	 * Default Constructor
	 */
	public ModeConverter() {
	}

	/**
	 * Overriden method for converting the String path to Mode enumeration
	 * instance.
	 *
	 * @return a instance of the Level enumeration.
	 */
	@Override
	public Mode convert(final String value) {
		final Mode convertedValue = Mode.fromString(value);
		if (convertedValue == null) {
			throw new ParameterException("Value " + value + "can not be converted to MODE. "
					+ "Please use the available values");
		}
		return convertedValue;
	}

}
