package de.upb.pga3.panda2.client.core.datastructures.validation;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;

/**
 *
 * Class for validating the input value of the ToolSpecificOption enumeration
 * from JCommander perspective for command line scenario.
 *
 * @author Sriram
 *
 */
public class ToolSpecificOptionConverter implements IStringConverter<ToolSpecificOption> {

	/**
	 * Default Constructor
	 */
	public ToolSpecificOptionConverter() {
	}

	/**
	 * Overriden method for converting the String path to ToolSpecificOption
	 * enumeration instance.
	 *
	 * @return a instance of the ToolSpecificOption enumeration.
	 */
	@Override
	public ToolSpecificOption convert(final String value) {
		final ToolSpecificOption convertedValue = ToolSpecificOption.fromString(value);
		if (convertedValue == null) {
			throw new ParameterException("Value " + value + " can not be converted to ToolSpecificOption. "
					+ "Please input the correct values");
		}
		return convertedValue;
	}
}
