package de.upb.pga3.panda2.client.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * This Config will be saved and loaded. By that the GUI will be able to
 * remember some input e.g. the last position choosen in the open dialog.
 *
 * @author Felix
 */
public final class GuiConfig implements Serializable {
	private static final long serialVersionUID = -5891500918384508046L;

	private static final Logger LOGGER = LogManager.getLogger(GuiConfig.class);

	private static GuiConfig INSTANCE = new GuiConfig();

	private File openFolder, saveFolder, apkFolder, prevResultFolder, nnApkFolder;

	private final File configFile = new File("data/temp/guiconfig.cfg");

	public static GuiConfig getInstance() {
		return INSTANCE;
	}

	private GuiConfig() {
		this.openFolder = null;
		this.saveFolder = null;
		this.apkFolder = null;
		this.prevResultFolder = null;
		this.nnApkFolder = null;
	}

	public void load() {
		try {
			if (this.configFile.exists()) {
				final ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.configFile));
				final GuiConfig load = (GuiConfig) ois.readObject();
				ois.close();

				setOpenFolder(load.getOpenFolder());
				setSaveFolder(load.getSaveFolder());
				setApkFolder(load.getApkFolder());
				setPrevResultFolder(load.getPrevResultFolder());
				setNnApkFolder(load.getNnApkFolder());
			} else {
				this.configFile.createNewFile();
			}
		} catch (final Exception e) {
			LOGGER.warn("Could not access gui config file.");
		}
	}

	private void save() {
		try {
			final ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.configFile));
			oos.writeObject(getInstance());
			oos.close();
		} catch (final IOException e) {
			LOGGER.warn("Could not access gui config file.");
		}
	}

	public File getOpenFolder() {
		return checkIfExists(this.openFolder);
	}

	public void setOpenFolder(final File openFolder) {
		this.openFolder = openFolder;
		save();
	}

	public File getSaveFolder() {
		return checkIfExists(this.saveFolder);
	}

	public void setSaveFolder(final File saveFolder) {
		this.saveFolder = saveFolder;
		save();
	}

	public File getApkFolder() {
		return checkIfExists(this.apkFolder);
	}

	public void setApkFolder(final File apkFolder) {
		this.apkFolder = apkFolder;
		save();
	}

	public File getPrevResultFolder() {
		return checkIfExists(this.prevResultFolder);
	}

	public void setPrevResultFolder(final File prevResultFolder) {
		this.prevResultFolder = prevResultFolder;
		save();
	}

	public File getNnApkFolder() {
		return checkIfExists(this.nnApkFolder);
	}

	public void setNnApkFolder(final File nnApkFolder) {
		this.nnApkFolder = nnApkFolder;
		save();
	}

	private static File checkIfExists(final File file) {
		try {
			if (file.exists()) {
				return file;
			} else {
				return null;
			}
		} catch (final NullPointerException e) {
			return null;
		}
	}
}
