/**
 *
 */
package de.upb.pga3.panda2.core.datastructures;

import java.util.HashMap;
import java.util.Map;

/**
 * IntentFilter class containts all elements and attributes if element
 * <\intent-filter>. Because intent-filter element just contains 3 attributes
 * and 3 elements, the class covers only 3 elements.
 *
 * @author nptsy
 */
public class IntentFilter {
	// 3 atributes are android:icon, android:label and android:priority
	// 3 elements are action, category and data

	// target name
	private String mStrTargetName;

	// action name
	private String mStrActionName;

	// category name
	private String mStrCategoryName;

	// map of data, key is the name of attribute and value is the value of
	// attribute
	private Map<String, String> mMapData;

	/**
	 * Construtor
	 */
	public IntentFilter(final String inTargetName) {
		this.mStrTargetName = inTargetName;
		this.mStrActionName = "";
		this.mStrCategoryName = "";
		this.mMapData = new HashMap<>();
	}

	/**
	 * set action name
	 *
	 * @param inName
	 *            name of action
	 */
	public void setActionName(final String inName) {
		this.mStrActionName = inName;
	}

	/**
	 * set category name
	 *
	 * @param inName
	 *            name of category
	 */
	public void setCategoryName(final String inName) {
		this.mStrCategoryName = inName;
	}

	/**
	 * add pair of key and value to map data
	 *
	 * @param inKey
	 *            the attribute name
	 * @param inValue
	 *            the value of attribute
	 */
	public void addData(final String inKey, final String inValue) {
		this.mMapData.put(inKey, inValue);
	}

	/**
	 * get map of data. Key is the name of attribute and value is the value if
	 * attribute
	 *
	 * @return map of data
	 */
	public Map<String, String> getMapData() {
		return this.mMapData;
	}

	/**
	 * get name of element targeted component
	 *
	 * @return name of targeted component
	 */
	public String getTargetName() {
		return this.mStrTargetName;
	}

	/**
	 * get name of element <\action>
	 *
	 * @return name of action
	 */
	public String getActionName() {
		return this.mStrActionName;
	}

	/**
	 * get name of element <\category>
	 *
	 * @return name of category
	 */
	public String getCategoryName() {
		return this.mStrCategoryName;
	}
}
