package de.upb.pga3.panda2.core.services;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;

/**
 * Mainly process xml to get information defined in xml files
 *
 * @author npts
 */
public final class A3XMLParser implements XMLParser {
	private static final A3XMLParser INSTANCE = new A3XMLParser();

	// parser used for manifest file
	private ManifestXMLParser mManifestParser;

	// parser used for CERT.RSA file
	private CertParser mCertificateParser;

	// parser used for layout files.
	private XMLLayoutParser layoutParser;

	// Parser to parse ARSC file
	private ARSCParser arscParser;

	private A3XMLParser() {
	}

	public static XMLParser getInstance() {
		return A3XMLParser.INSTANCE;
	}

	/**
	 * fetch data to the parser by specifying the path of APK file. This should
	 * be call before getting any information
	 */
	@Override
	public void fetchData(final String inAPKPath) {
		this.mManifestParser = new ManifestXMLParser(inAPKPath);
		this.mCertificateParser = new CertParser(inAPKPath);

		this.layoutParser = new XMLLayoutParser(A3XMLParser.getInstance().getManifestInformation().getPackage(),
				inAPKPath, A3XMLParser.getInstance().getLstActivities());

		this.arscParser = new ARSCParser();
		try {
			this.arscParser.parse(inAPKPath);
		} catch (final IOException e) {

			e.printStackTrace();
		}
	}

	@Override
	public Map<String, String> getRequiredPermissions() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getRequiredPermissions();
		}
		return null;
	}

	@Override
	public String getFingerprint() {
		return this.mCertificateParser.getMd5Fingerprint();
	}

	@Override
	public ManifestInfo getManifestInformation() {
		if (this.mManifestParser != null) {
			final ManifestInfo manifestinfo = this.mManifestParser.getManifestInfo();
			manifestinfo.setIntentFilters(getIntentFilters());
			return manifestinfo;
		}
		return null;
	}

	@Override
	public Map<String, String> getContentProviderURIs() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getContentProviderURIs();
		}
		return null;
	}

	@Override
	public List<IntentFilter> getIntentFilters() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getIntentFilters();
		}
		return null;
	}

	@Override
	public String getAppName() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getAppName();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.upb.pga3.panda2.core.services.XMLParser#getUsesPermission()
	 */
	@Override
	public List<String> getUsesPermission() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getUsesPermission();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.upb.pga3.panda2.core.services.XMLParser#getLstActivities()
	 */
	@Override
	public List<String> getLstActivities() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getLstActivities();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.upb.pga3.panda2.core.services.XMLParser#getLstProviders()
	 */
	@Override
	public List<String> getLstProviders() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getLstProviders();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.upb.pga3.panda2.core.services.XMLParser#getLstReceivers()
	 */
	@Override
	public List<String> getLstReceivers() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getLstReceivers();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.upb.pga3.panda2.core.services.XMLParser#getLstServices()
	 */
	@Override
	public List<String> getLstServices() {
		if (this.mManifestParser != null) {
			return this.mManifestParser.getLstServices();
		}
		return null;
	}

	@Override
	public XMLLayoutParser getLayoutParser() {

		return this.layoutParser;
	}

	@Override
	public ARSCParser getArscParser() {
		return this.arscParser;
	}

}
