package de.upb.pga3.panda2.core.services;

/**
 * @author RamKumar
 */

/* Class represent XML attruibutes */

public class XMLAttribute<T> extends XMLElement {

	/* The attribute's name. */

	protected String name;
	protected int type;
	protected T value;
	protected int resourceId;

	public static final int TYPE_INT_BOOLEAN = 0x00000012;
	public static final int TYPE_STRING = 0x00000003;
	public static final int TYPE_FIRST_INT = 0x00000010;
	public static final int TYPE_INT_HEX = 0x00000011;
	public static final int TYPE_REFERENCE = 0x00000001;

	public XMLAttribute(final String name, final T value, final String ns) {
		this(name, -1, value, ns, true);
	}

	public XMLAttribute(final String name, final int resourceId, final T value, final String ns) {
		this(name, resourceId, value, ns, true);
	}

	public XMLAttribute(final String name, final int resourceId, final T value, final String ns, final boolean added) {
		this(name, resourceId, -1, value, ns, added);
	}

	public XMLAttribute(final String name, final int resourceId, final int type, final T value, final String ns,
			final boolean added) {
		super(ns, added);
		this.name = name;
		this.resourceId = resourceId;
		this.type = type;
		this.value = value;
	}

	/**
	 * return attribute's name
	 *
	 * @return attribute name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 *
	 * @return Resource ID of the attribute
	 */
	public int getResourceId() {
		return this.resourceId;
	}

	/**
	 * Used to set value to an attribute
	 *
	 * @param value
	 *            Attribute value
	 */
	public void setValue(final T value) {
		this.value = value;
	}

	/**
	 * Return the value
	 *
	 * @return value
	 */
	public T getValue() {
		return this.value;
	}

	/**
	 * Return the type of value
	 *
	 * @return value type
	 */
	public int getType() {
		if (this.value instanceof Integer) {
			return TYPE_INT_HEX;
		} else if (this.value instanceof Boolean) {
			return TYPE_INT_BOOLEAN;
		} else {
			return TYPE_STRING;
		}
	}

	/**
	 * Returns attributes type
	 *
	 * @return attribute type
	 */
	public int getAttributeType() {
		return this.type;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final XMLAttribute<?> other = (XMLAttribute<?>) obj;
		if (this.name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!this.name.equals(other.name)) {
			return false;
		}
		if (this.resourceId != other.resourceId) {
			return false;
		}
		if (this.type != other.type) {
			return false;
		}
		if (this.value == null) {
			if (other.value != null) {
				return false;
			}
		} else if (!this.value.equals(other.value)) {
			return false;
		}
		return true;
	}
}
