package de.upb.pga3.panda2.core.services;

import java.util.List;
import java.util.Map;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;

public interface XMLParser {
	// public Map<String, List<String>> getRequiredPermissions();
	public Map<String, String> getRequiredPermissions();

	// get finger print of android application
	public String getFingerprint();

	// get manifest info
	public ManifestInfo getManifestInformation();

	// public Map<String, List<String>> getContentProviderURIs();
	public Map<String, String> getContentProviderURIs();

	// get intent filters of each android components defined in manifest file
	public List<IntentFilter> getIntentFilters();

	// get uses permissions defined in manifest file
	public List<String> getUsesPermission();

	// get android application name
	public String getAppName();

	// load data from file
	public void fetchData(String inAPKFile);

	// get list of defined activities inside the manifest file
	public List<String> getLstActivities();

	// get list of defined providers inside the manifest file
	public List<String> getLstProviders();

	// get list of defined receivers inside the manifest file
	public List<String> getLstReceivers();

	// get list of defined services inside the manifest file
	public List<String> getLstServices();

	// return instance of LayoutParser
	public XMLLayoutParser getLayoutParser();

	// return instance of ARSCParser
	public ARSCParser getArscParser();
}
