package de.upb.pga3.panda2.extension.lvl1.analyzer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.Analyzer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;

/**
 * This is the specific Analyzer for Level 1.
 *
 * @author Felix
 *
 */
public class AnalyzerLvl1 implements Analyzer {
	// Logger initialization
	private static final Logger LOGGER = LogManager.getLogger(AnalyzerLvl1.class);

	@Override
	public AnalysisResult analyze(final AnalysisGraph ag, final AnalysisResult prevRes) {
		// Run analyzer
		LOGGER.info("Analyzer started (Permission usage - Intra App - Level 1).");

		final AnalysisResultLvl1 anaResult = new ManifestPermissionComparerLvl1().compare(ag);

		if (prevRes != null) {
			anaResult.compare(prevRes);
		}

		LOGGER.info("Analyzer finished (Permission usage - Intra App - Level 1).");
		return anaResult;
	}
}