package de.upb.pga3.panda2.extension.lvl1.graphgenerator;

import java.nio.file.Path;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.extension.GraphGenerator;

/**
 * This is the specific GraphGenerator for Level 1.
 *
 * @author Felix
 *
 */
public class GraphGeneratorLvl1 implements GraphGenerator {
	// Logger initialization
	private static final Logger LOGGER = LogManager.getLogger(GraphGeneratorLvl1.class);

	@Override
	public AnalysisGraph generateGraph(final Input in, final Path apk) {
		LOGGER.info("GraphGenerator started (Permission usage - Intra App - Level 1).");

		final IntentAnalyzerLvl1 intentAnalyzer = new IntentAnalyzerLvl1((EnhancedInput) in);
		intentAnalyzer.analyzeExplicitIntents();

		LOGGER.info("GraphGenerator finished (Permission usage - Intra App - Level 1).");
		return intentAnalyzer.getGraph();
	}
}
