package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import java.util.HashMap;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import soot.SootMethod;

public final class MethodElement implements PathElement {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -1074736691487482090L;

	private static final Map<MethodElement, MethodElement> instancePool = new HashMap<>();

	private final String methodSubSignature;
	private final ClassElement clazz;

	public static MethodElement get(final SootMethod method, final EnhancedInput input) {

		MethodElement methodEle = new MethodElement(method, input);
		if (instancePool.containsKey(methodEle)) {
			methodEle = instancePool.get(methodEle);
		} else {
			instancePool.put(methodEle, methodEle);
		}
		return methodEle;
	}

	private MethodElement(final SootMethod method, final EnhancedInput input) {

		if (method == null) {
			throw new IllegalArgumentException("The given method must not be null!");
		}
		if (input == null) {
			throw new IllegalArgumentException("The given enhanced input must not be null!");
		}

		this.methodSubSignature = method.getSubSignature();
		this.clazz = ClassElement.get(method.getDeclaringClass(), input);
	}

	public String getMethodSubSignature() {
		return toString();
	}

	public ClassElement getClassElement() {
		return this.clazz;
	}

	@Override
	public String toFullString() {
		return this.clazz.toFullString() + "\n" + toString();
	}

	@Override
	public String toString() {
		return this.methodSubSignature;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.clazz == null) ? 0 : this.clazz.hashCode());
		result = prime * result + ((this.methodSubSignature == null) ? 0 : this.methodSubSignature.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final MethodElement other = (MethodElement) obj;
		if (this.clazz == null) {
			if (other.clazz != null) {
				return false;
			}
		} else if (!this.clazz.equals(other.clazz)) {
			return false;
		}
		if (this.methodSubSignature == null) {
			if (other.methodSubSignature != null) {
				return false;
			}
		} else if (!this.methodSubSignature.equals(other.methodSubSignature)) {
			return false;
		}
		return true;
	}

}
