package de.upb.pga3.panda2.extension.lvl2b;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is used as data structure for the analysis Level 2b result. It
 * simply holds an arbitrary amount of leafs.
 *
 * @author Felix
 *
 */
public class ResultTreeLvl2b {
	private Map<String, ResultLeafLvl2b> leafs;

	public ResultTreeLvl2b() {
		this.leafs = new HashMap<>();
	}

	public Map<String, ResultLeafLvl2b> getLeafs() {
		return this.leafs;
	}

	public List<ResultLeafLvl2b> getLeafsAsList() {
		return new ArrayList<>(this.leafs.values());
	}

	public void addLeaf(final ResultLeafLvl2b leaf) {
		this.leafs.put(leaf.getName(), leaf);
	}

	public ResultLeafLvl2b getLeaf(final String key) {
		return this.leafs.get(key);
	}
}