package de.upb.pga3.panda2.extension.lvl2b.analyzer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.Analyzer;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;

/**
 * This is the specific Analyzer for Level 2b.
 *
 * @author Felix
 *
 */
public class AnalyzerLvl2b implements Analyzer {
	// Logger initialization
	private static final Logger LOGGER = LogManager.getLogger(AnalyzerLvl2b.class);

	private boolean allmode;

	public AnalyzerLvl2b(final boolean allmode) {
		this.allmode = allmode;
	}

	@Override
	public AnalysisResult analyze(final AnalysisGraph ag, final AnalysisResult prevRes) {
		// Run analyzer
		LOGGER.info("Analyzer started (Permission usage - Inter App - Level 2b).");

		final AnalysisResultLvl2b anaResult = new ManifestPermissionComparerLvl2b(this.allmode).compare(ag);

		if (prevRes != null) {
			anaResult.compare(prevRes);
		}

		LOGGER.info("Analyzer finished (Permission usage - Inter App - Level 2b).");
		return anaResult;
	}
}
