package de.upb.pga3.panda2.test.client.cmdline;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.cmdline.CommandLine;
import de.upb.pga3.panda2.client.core.AnalysisRegistry;

/**
 * Test case for the class CommandLine.
 *
 * @author Sriram
 *
 */
public class CommandLineTest {
	String[] initialArguments1;
	String[] initialArguments2;
	String[] initialArguments3;
	String[] initialArguments4;
	String[] initialArguments5;
	String[] initialArguments6;
	String[] initialArguments7;

	final CommandLine cmdL = new CommandLine();

	@Before
	public void setUp() throws Exception {
		this.initialArguments1 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v",
				"textual", "-ts", "true" };

		this.initialArguments2 = new String[] { "-l", "level1", "-i", "-r", "view", "-v", "textual" };

		this.initialArguments3 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "save",
				"-fp", "test_resources/anaResult1.pa2", "-ts", "true" };

		this.initialArguments4 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-ci",
				"test_resources/anaResult1.pa2", "-r", "save", "-fp", "test_resources/anaResult2.pa2", "-ts", "true" };

		this.initialArguments5 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v",
				"message", "-ts", "false" };

		this.initialArguments6 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v",
				"textual", "-ts", "true", "-f", "REQUIRED", "-dl", "APP" };

		this.initialArguments7 = new String[] { "-opt", "load", "-fp", "test_resources/anaResult1.pa2" };
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void validateInitialInputPosTest() {

		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments1);
		assertTrue(out1);
	}

	@Test
	public void validateInitialInputNegTest() {

		final boolean out2 = this.cmdL.validateInitialInput(this.initialArguments2);
		assertFalse(out2);
	}

	@Test
	public void filterResultPostest() {
		validateInitialInputPosTest();
		this.cmdL.saveOrShowResult();
		this.cmdL.filterResult();
		System.out.println(this.cmdL.toString());
		assertNotNull(this.cmdL);

	}

	@Test
	public void saveOrShowResultPosTest() {
		validateInitialInputPosTest();
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
	}

	@Test
	public void validateAndCompareInputtest() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments4);
		assertTrue(out1);
		this.cmdL.validateAndCompareInput();
		assertNotNull(this.cmdL);
	}

	@Test
	public void saveResultPosTest() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments3);
		assertTrue(out1);
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
		assertTrue(new File("test_resources/anaResult1.pa2").isFile());
	}

	@Test
	public void saveResultComparisonTest() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments4);
		assertTrue(out1);
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
		assertTrue(new File("test_resources/anaResult2.pa2").isFile());
	}

	@Test
	public void showResultMessageTest() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments5);
		assertTrue(out1);
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
	}

	@Test
	public void showResultWithInitialFilterTest() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments6);
		assertTrue(out1);
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
	}

	@Test
	public void loadResult() {
		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments7);
		assertTrue(out1);
		this.cmdL.saveOrShowResult();
		assertNotNull(this.cmdL);
	}

	@Test
	public void getDetailLevelList() {

		final boolean out1 = this.cmdL.validateInitialInput(this.initialArguments7);
		assertTrue(out1);
		this.cmdL.getClientCommandLine().viewPreviousAnalysisResult();
		assertFalse(AnalysisRegistry.getInstance().getName(this.cmdL.getClientCommandLine().getAnalysisResult())
				.equals(AnalysisRegistry.UNKNOWN));
		assertTrue(this.cmdL.getClientCommandLine().getDetailLevels().size() > 0);

	}

}
