package de.upb.pga3.panda2.test.client.core.datastructures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.validation.ModeConverter;

/**
 *
 * @author Arjya
 *
 */
public class ModeTest {

	Mode mode;

	@Before
	public void setUp() throws Exception {

		final ModeConverter mc = new ModeConverter();
		this.mode = mc.convert("S");
	}

	@Test
	public void getValuestest() {
		assertNotNull(this.mode.getValues().size());
	}

	@Test
	public void getValuesValuetest() {
		assertEquals("SUM", this.mode.getValues().get(0).toString());
	}

	@Test
	public void getValuesNegativetest() {
		assertNotEquals("somevalues", this.mode.getValues().get(0).toString());
	}

	@Test
	public void fromStringtest() {
		assertNotNull(Mode.fromString("S"));
	}

	@Test
	public void fromStringValuetest() {
		assertEquals("SUMMARY", Mode.fromString("S").toString());
	}

	@Test
	public void fromStringNegativetest() {
		assertNull(Mode.fromString(""));
	}

}
