package de.upb.pga3.panda2.test.client.core.datastructures.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.validation.ModeConverter;

/**
 *
 * @author Anand
 *
 */
public class ModeConverterTest {

	private String mode;
	private String modeInvalid;

	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		this.mode = "summary";
		this.modeInvalid = "dummy";
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void converttest() {
		final ModeConverter mc = new ModeConverter();
		final Mode mode = mc.convert(this.mode);
		assertNotNull(mode);
	}

	@Test
	public void convertValuetest() {
		final ModeConverter mc = new ModeConverter();
		final Mode mode = mc.convert(this.mode);
		assertEquals(Mode.SUMMARY, mode);
	}

	@Test
	public void convertNegetivetest() {
		final ModeConverter mc = new ModeConverter();

		this.exception.expect(ParameterException.class);
		final Mode mode = mc.convert(this.modeInvalid);
		assertNull(mode);

	}

}
