package de.upb.pga3.panda2.test.core.datastructures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;

/**
 *
 * @author Anand
 *
 */
public class AnalysisGraphTest {
	Input inp;
	AnalysisGraph ag = new AnalysisGraph(this.inp);

	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void addMessagetest() {
		final MessageType mType = MessageType.INFO;
		final String inTitle = "Title";
		final String inBody = "Body";
		final Message inMsg = new Message(mType, inTitle, inBody);
		this.ag.addMessage(inMsg);
		assertNotNull(inMsg);
	}

	@Test
	public void getMessagestest1() {
		final MessageType mType = MessageType.INFO;
		final String inTitle = "Title";
		final String inBody = "Body";
		final Message inMsg = new Message(mType, inTitle, inBody);
		this.ag.addMessage(inMsg);
		List<Message> lst = new ArrayList<Message>();
		lst = this.ag.getMessages();
		assertNotNull(lst);
	}

	@Test
	public void getMessagestest2() {
		final MessageType mType = MessageType.INFO;
		final String inTitle = "Title";
		final String inBody = "Body";
		final Message inMsg = new Message(mType, inTitle, inBody);
		this.ag.addMessage(inMsg);
		List<Message> lst = new ArrayList<Message>();
		lst = this.ag.getMessages();
		assertEquals(true, lst.get(0).getBody().toString().contains(inBody));
	}

	@Test
	public void getHeadstest() {
		this.exception.expect(UnsupportedOperationException.class);
		final List<Object> lst = this.ag.getHeads();
		assertNotNull(lst);
	}

	@Test
	public void getTailstest() {
		this.exception.expect(UnsupportedOperationException.class);
		final List<Object> lst = this.ag.getTails();
		assertNotNull(lst);
	}

}
