package de.upb.pga3.panda2.test.core.datastructures;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.demos.EnhancedInputForTestingNew;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

/**
 *
 * @author Anand
 *
 */
public class EnhancedInputTest {
	EnhancedInput ei;
	EnhancedInputForTestingNew eiN;

	String AppName = "SimpleIntents";
	String className = "MainActivity";
	String methodName = "launch_explicit";
	String appFingerprint = "24ca4ad37466d705700ec339e048f0e5";
	SootMethod m = null;
	List<Type> parameterTypes;
	ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();
	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {

		this.ei = new EnhancedInput(this.AppName, this.manifestInfo);
		this.eiN = new EnhancedInputForTestingNew();
		// this.ei = new EnhancedInputForTestingNew(AppName,appFingerprint);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void addPermissionTotest() {
		final Permission[] p = { new Permission("INTERNET") };
		this.ei.addPermissionTo(null, p[0]);

	}

	@Test
	public void getComponentByNametest() {

		final Permission[] p = { new Permission("INTERNET") };
		this.ei = new EnhancedInput(this.AppName, this.manifestInfo);
		final String inComponentName = "MainActivity";
		final SootClass sc = this.ei.getComponentByName(inComponentName);
		assertEquals(null, sc);

	}

	@Test
	public void getAppName() {
		final Permission[] p = { new Permission("INTERNET") };
		this.ei = new EnhancedInput(this.AppName, this.manifestInfo);
		final String appName = this.ei.getAppName();
		assertEquals("SimpleIntents", appName);

	}

}
