package de.upb.pga3.panda2.test.extension.lvl1;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.Before;
import org.junit.Test;

import soot.SootClass;
import soot.SootMethod;

import com.google.common.collect.Iterables;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.analyzer.ManifestPermissionComparerLvl1;

/**
 *
 * @author Anand
 *
 */
public class ManifestPermissionComparerLvl1Test {
	private static ManifestPermissionComparerLvl1 mpc;
	private static AnalysisGraph analysisGraph;
	private static EnhancedInput enhancedInput;

	@Before
	public void before() {
		SootAdapter.getInstance().reinitSoot();
	}

	@Test
	public void comparePermissionAssignedtest() {
		final Path apkFile = Paths.get("test_resources/SimpleRequiredInternetP.apk");
		final Enhancer enhancer = new Enhancer();
		ManifestPermissionComparerLvl1Test.analysisGraph = new AnalysisGraph(enhancer.enhance(apkFile));
		ManifestPermissionComparerLvl1Test.mpc = new ManifestPermissionComparerLvl1();

		final AnalysisResultLvl1 analysisResult = ManifestPermissionComparerLvl1Test.mpc
				.compare(ManifestPermissionComparerLvl1Test.analysisGraph);
		final EnhancedInput ei = (EnhancedInput) analysisResult.getAnalysisGraph().getInput();

		Permission permissionClass = null;
		Permission permissionMethod = null;
		for (final SootClass classOrComponent : ei.getAppClasses()) {
			if (classOrComponent.toString().contains("MainActivity")) {
				permissionClass = Iterables.get(ei.getPermissionsFor(classOrComponent), 0);
				for (final SootMethod method : classOrComponent.getMethods()) {
					if (method.toString().contains("onCreate")) {
						permissionMethod = Iterables.get(ei.getPermissionsFor(method), 0);
						break;
					}
				}
				break;
			}
		}

		// Check
		assertNotNull(permissionClass);
		assertEquals("android.permission.INTERNET", permissionClass.getName());
		assertNotNull(permissionMethod);
		assertEquals("android.permission.INTERNET", permissionMethod.getName());
		assertEquals(true, ei.getMaybeMoreList().isEmpty());
	}

	@Test
	public void compareMaybeMoretest() {
		final Path apkFile = Paths.get("test_resources/SimpleIntents.apk");
		final Enhancer enhancer = new Enhancer();
		ManifestPermissionComparerLvl1Test.enhancedInput = (EnhancedInput) enhancer.enhance(apkFile);

		assertEquals(false, ManifestPermissionComparerLvl1Test.enhancedInput.getMaybeMoreList().isEmpty());
	}
}
