package de.upb.pga3.panda2.test.extension.lvl1.graphgenerator;

import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.IntentAnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.NodeLinkerLvl1;

/**
 *
 * @author Anand
 *
 */
public class NodeLinkerLvl1Test {
	Enhancer enhancer;
	EnhancedInput enhInput;
	GraphGeneratorLvl1 ggl;
	IntentAnalyzerLvl1 intentAnalyzer;
	NodeLinkerLvl1 nl;
	AnalysisGraph ag;
	IntentInformation ii;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {

		final Path p = Paths.get("test_resources/SimpleIntents.apk");
		this.enhancer = new Enhancer();
		this.enhInput = (EnhancedInput) this.enhancer.enhance(p);
		this.ggl = new GraphGeneratorLvl1();
		this.ag = this.ggl.generateGraph(this.enhInput, p);
		this.intentAnalyzer = new IntentAnalyzerLvl1(this.enhInput);

		final List<SootClass> testclass = findClasses((EnhancedInput) (this.intentAnalyzer.getGraph().getInput()));
		final Unit testStmt = findStmt("MainActivity", "launch_explicit", "(android.content.Context,java.lang.Class)",
				(EnhancedInput) (this.intentAnalyzer.getGraph().getInput()));

		// this.ii = new IntentInformation(false, testStmt, 1, testclass);

		this.ii = new IntentInformation(-1);

	}

	private static Unit findStmt(final String className, final String methodName, final String unitCharSeq,
			final EnhancedInput ei) {
		Unit u = null;
		for (final SootClass componentOrClass : ei.getAppClasses()) {
			if (componentOrClass.getName().toString().contains(className)) {
				for (final SootMethod method : componentOrClass.getMethods()) {
					if (method.getName().toString().contains(methodName)) {
						if (!componentOrClass.isInterface()) {
							final Body body = method.retrieveActiveBody();
							for (final Unit stm : body.getUnits()) {
								if (stm.toString().contains(unitCharSeq)) {
									u = stm;
								}
							}
						}
					}
				}
			}
		}
		return u;
	}

	private static List<SootClass> findClasses(final EnhancedInput ei) {
		final List<SootClass> sootclassLst = new ArrayList<>();
		final SootClass[] classes = ei.getAppClasses();
		for (final SootClass c : classes) {
			System.out.println(c);
			sootclassLst.add(c);
		}
		return sootclassLst;
	}

	@After
	public void tearDown() throws Exception {
	}

	// @Test
	// public void nodelinkertest() {
	//
	// this.ii = new IntentInformation(-1);
	// this.nl = new NodeLinkerLvl1(this.ag);
	// this.nl.link(this.ii);
	//
	// final Transition[] outgoingTransitions =
	// this.nl.getGraph().getOutgoingTransitions(testStmt)
	// .toArray(new Transition[0]);
	// System.out.println(this.nl.getGraph().getOutgoingTransitions(testStmt).toArray(new
	// Transition[0]).length);
	// final boolean targetReached = ((SootClass)
	// (outgoingTransitions[0].getTarget())).getName().toString()
	// .contains("com.mycompany.simpleintents.Hello");
	//
	// assertNotNull(outgoingTransitions);
	// assertEquals(false, targetReached);
	//
	// }

	@Test
	public void nodelinkertest() {

		this.nl = new NodeLinkerLvl1(this.ag);
		this.nl.link(this.ii);
		assertNotNull(this.nl.getGraph().getOutgoingTransitions(this.ii).toString());
	}

}
