/**
 *
 */
package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.BackwardSlicer;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import soot.Unit;

/**
 * JUnit test for backward slicing computer
 *
 * @author nptsy
 */
public class BackwardSlicerTest {

	@Test
	public void testConstructor() {
		final BackwardSlicer mBackwardSlicer = new BackwardSlicer();
		assertNotNull(mBackwardSlicer);
	}

	@Test
	public void testSlicingAlgo() {
		final BackwardSlicer mBackwardSlicer = new BackwardSlicer();

		final SourceAndSinkComputer fixture = new SourceAndSinkComputer();
		final AnalysisGraph graph = TestCodeFactory.createAnalysisGraph("test_resources/ExpoAppLvl2a.apk");
		final Object[] lstNode = graph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> sinks = fixture.computeSinks(lstNodeUnit, (EnhancedInput) graph.getInput());
		final Map<Permission, List<Unit>> sources = fixture.computeSources(lstNodeUnit,
				(EnhancedInput) graph.getInput());

		for (final Map.Entry<Permission, List<Unit>> entry : sinks.entrySet()) {
			// permission
			final Permission perm = entry.getKey();
			// list of sink
			final List<Unit> lstSinks = entry.getValue();
			for (final Unit sink : lstSinks) {
				final Map<Permission, List<Unit>> mapPermSources = mBackwardSlicer.slice((AnalysisGraphLvl2a) graph,
						sink, sources);
				assertNotNull(mapPermSources);
			}
		}
	}

	@Test
	public void testSlicingAlgo2() {
		final BackwardSlicer mBackwardSlicer = new BackwardSlicer();

		final SourceAndSinkComputer fixture = new SourceAndSinkComputer();
		final AnalysisGraph graph = TestCodeFactory.createAnalysisGraph("test_resources/TestIfElseCase.apk");
		final Object[] lstNode = graph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> sinks = fixture.computeSinks(lstNodeUnit, (EnhancedInput) graph.getInput());
		final Map<Permission, List<Unit>> sources = fixture.computeSources(lstNodeUnit,
				(EnhancedInput) graph.getInput());

		for (final Map.Entry<Permission, List<Unit>> entry : sinks.entrySet()) {
			// permission
			final Permission perm = entry.getKey();
			// list of sink
			final List<Unit> lstSinks = entry.getValue();
			for (final Unit sink : lstSinks) {
				final Map<Permission, List<Unit>> mapPermSources = mBackwardSlicer.slice((AnalysisGraphLvl2a) graph,
						sink, sources);
				assertNotNull(mapPermSources);
			}
		}
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 29.02.16 11:24
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 29.02.16 11:24
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 29.02.16 11:24
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(BackwardSlicerTest.class);
	}
}
