package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.CallBackAnalyser;
import soot.SootMethod;

/**
 * The class <code>CallBackAnalyserTest</code> contains tests for the class
 * <code>{@link CallBackAnalyser}</code>.
 *
 * @generatedBy CodePro at 29/02/16 02:31
 * @author RamKumar
 * @version $Revision: 1.0 $
 */
public class JUnitCallBackAnalyserTest {

	Set<String> androidCallBacks;
	Set<String> entryPointClasses;

	/**
	 * Run the CallBackAnalyser() constructor test.
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Test
	public void testCallBackAnalyser_1() throws Exception {
		final CallBackAnalyser result = new CallBackAnalyser();
		assertNotNull(result);
		// add additional test code here
	}

	/**
	 * Run the Map<String, TIntList> getActivityLayoutIDMap() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Test
	public void testGetActivityLayoutIDMap_1() throws Exception {
		final CallBackAnalyser fixture = new CallBackAnalyser();
		fixture.setInputs(this.androidCallBacks, this.entryPointClasses);

		final Map<String, List<Integer>> result = fixture.getActivityLayoutIDMap();

		// add additional test code here
		assertNotNull(result);
		assertEquals(0, result.size());
	}

	/**
	 * Run the Map<String, List<SootMethod>> getCallBackMethods() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Test
	public void testGetCallBackMethods_1() throws Exception {
		final CallBackAnalyser fixture = new CallBackAnalyser();
		fixture.setInputs(this.androidCallBacks, this.entryPointClasses);

		final Map<String, List<SootMethod>> result = fixture.getCallBackMethods();

		// add additional test code here
		assertNotNull(result);
		assertEquals(0, result.size());
	}

	/**
	 * Run the CallBackAnalyser getInstance() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Test
	public void testGetInstance_1() throws Exception {

		final CallBackAnalyser result = CallBackAnalyser.getInstance();

		// add additional test code here
		assertNotNull(result);
	}

	/**
	 * Run the void setInputs(Set<String>,Set<String>) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Test
	public void testSetInputs_1() throws Exception {
		final CallBackAnalyser fixture = new CallBackAnalyser();
		fixture.setInputs(this.androidCallBacks, this.entryPointClasses);
		assertNotNull(this.androidCallBacks);
		assertNotNull(this.entryPointClasses);
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@Before
	public void setUp() throws Exception {
		// add additional set up code here

		final String apkLoc = "test_resources/Lvl2AMoreTestCases/WordSwirlV2.apk";
		final Path apkPath = Paths.get(apkLoc);

		final Enhancer enhancer = new Enhancer();
		enhancer.enhance(apkPath);

		this.androidCallBacks = CoreServices.getDataStorageInstance().getCallBackClasses();

		final List<String> lstActivities = CoreServices.getXMLParserInstance().getLstActivities();
		final List<String> lstProviders = CoreServices.getXMLParserInstance().getLstProviders();
		final List<String> lstReceivers = CoreServices.getXMLParserInstance().getLstReceivers();
		final List<String> lstServices = CoreServices.getXMLParserInstance().getLstServices();
		final Set<String> entryPoints = new HashSet<>();
		// activities
		if (lstActivities != null) {
			for (final String actName : lstActivities) {
				entryPoints.add(actName);
			}
		}
		// content providers
		if (lstProviders != null) {
			for (final String proName : lstProviders) {
				entryPoints.add(proName);
			}
		}
		// broadcast receivers
		if (lstReceivers != null) {
			for (final String recName : lstReceivers) {
				entryPoints.add(recName);
			}
		}
		// services
		if (lstServices != null) {
			for (final String serName : lstServices) {
				entryPoints.add(serName);
			}
		}

		this.entryPointClasses = entryPoints;

	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 29/02/16 02:31
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(JUnitCallBackAnalyserTest.class);
	}
}