package de.upb.pga3.panda2.test.extension.lvl2a;

import java.nio.file.Path;
import java.nio.file.Paths;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.AnalyzerLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.GraphGeneratorLvl2a;

/**
 * @author Fabian
 * @author Monika
 *
 */
public class TestCodeFactory {

	public static Input createEnhancedInput(final String apkPath) {
		SootAdapter.getInstance().reinitSoot();
		final Path testAPK = Paths.get(apkPath);
		A3XMLParser.getInstance().fetchData(testAPK.toString());
		SootAdapter.getInstance().init(testAPK);

		final Enhancer e = new Enhancer();
		final Input ei = e.enhance(testAPK);
		return ei;
	}

	public static AnalysisResult createAnalysisResult(final String apkPath) {
		final AnalysisGraph graph = createAnalysisGraph(apkPath);
		final AnalyzerLvl2a analyzer = new AnalyzerLvl2a();
		return analyzer.analyze(graph, null);
	}

	public static AnalysisGraph createAnalysisGraph(final String apkPath) {
		final Input input = createEnhancedInput(apkPath);
		final GraphGeneratorLvl2a gg = new GraphGeneratorLvl2a();
		return gg.generateGraph(input, null);
	}

}
