// 
// (c) 2012 University of Luxembourg - Interdisciplinary Centre for 
// Security Reliability and Trust (SnT) - All rights reserved
//
// Author: Alexandre Bartel
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>. 
//

package soot.dexpler;

import soot.options.Options;

public class Debug {
  public static boolean DEXPLER_DEBUG;
  
  public static void printDbg (String s, Object...objects) {
    DEXPLER_DEBUG = Options.v().verbose();
    if (DEXPLER_DEBUG) {
      for (Object o: objects) {
          if (o == null)
              s += "null";
          else
              s += o.toString();
      }
      System.out.println (s);
    }
      
  }
  
  public static void printDbg (boolean c, String s, Object...objects) {
      if (c)
          printDbg(s, objects);
  }
}
